#ifndef _DM_SPI_H__
#define _DM_SPI_H__

////////////////////////////////////////////////////////////////////////////////

#include "dm_nutypedefs.h"

////////////////////////////////////////////////////////////////////////////////
#ifdef __cplusplus
extern "C" {
#endif

#ifdef DM_WINCE

#define DM_WINCE_SPI_STAT_TABLE_ENTRIES             1024
#define DM_WINCE_SPI_STAT_MAX_CHANNELS              8
#define DM_WINCE_SPI_STAT_ALL_CHANNELS              0xFF

typedef struct
{
    UINT8 bDeviceIndex;
    UINT8 bAddr;
    UINT8 bNumBytes;
    UINT8 bIsRead;
    UINT32 lElapsedTicks;
} DM_WINCE_SPI_STAT_ENTRY;

struct DM_WINCE_SPI_STAT_CHANNEL
{
    BOOL bStatsEnabled;
    UINT32 lStatTableCount;
    DM_WINCE_SPI_STAT_ENTRY StatTable[DM_WINCE_SPI_STAT_TABLE_ENTRIES];
};

void DmResetStatsSPI( UINT8 bChannel );
void DmEnableStatsSPI( UINT8 bChannel, BOOL bEnable );
void DmPrintStatsSPI( UINT8 bChannel );
void DmAddStatSPI( UINT8 bChannel, DM_WINCE_SPI_STAT_ENTRY* pEntry );
BOOL DmIsEnabledStatsSPI( UINT8 bChannel );

INT32 DmWinSpiDeviceProcessInput(UINT32 inst, UINT32 cmd, UINT8 * pData, UINT32 * pDataBytes);

#endif

//This SPI bus enumeration is used on the ARM/Coldfire platforms in order to not change anything

enum
{
    DM_SPI_BUS_0 = 0,
    DM_SPI_BUS_1,
	DM_SPI_BUS_2,
	DM_SPI_BUS_3,
    MAX_DM_SPI_BUSES
};
#define IsValidDmSpiBus(a)              ( ((UINT8)a) < MAX_DM_SPI_BUSES )



//This SPI bus enumeration is used on the DM WinCE platform where the port processor could theoretically have infinite buses
//"Base 1 naming" is on purpose to maintain similarity with dm_i2c.h
enum
{
    DM_VIRTUAL_SPI_BUS_1 = 0,
    DM_VIRTUAL_SPI_BUS_2,
    DM_VIRTUAL_SPI_BUS_3,
    DM_VIRTUAL_SPI_BUS_4,
    DM_VIRTUAL_SPI_BUS_5,
    DM_VIRTUAL_SPI_BUS_6,
    DM_VIRTUAL_SPI_BUS_7,
    DM_VIRTUAL_SPI_BUS_8,
    DM_VIRTUAL_SPI_BUS_9,
    DM_VIRTUAL_SPI_BUS_10,
    DM_VIRTUAL_SPI_BUS_11,
    DM_VIRTUAL_SPI_BUS_12,
    DM_VIRTUAL_SPI_BUS_13,
    DM_VIRTUAL_SPI_BUS_14,
    DM_VIRTUAL_SPI_BUS_15,
    DM_VIRTUAL_SPI_BUS_16,
    DM_VIRTUAL_SPI_BUS_17,
    DM_VIRTUAL_SPI_BUS_18,
    DM_VIRTUAL_SPI_BUS_19,
    DM_VIRTUAL_SPI_BUS_20,
    DM_VIRTUAL_SPI_BUS_21,
    DM_VIRTUAL_SPI_BUS_22,
    DM_VIRTUAL_SPI_BUS_23,
    DM_VIRTUAL_SPI_BUS_24,
    DM_VIRTUAL_SPI_BUS_25,
    DM_VIRTUAL_SPI_BUS_26,
    DM_VIRTUAL_SPI_BUS_27,
    DM_VIRTUAL_SPI_BUS_28,
    DM_VIRTUAL_SPI_BUS_29,
    DM_VIRTUAL_SPI_BUS_30,
    DM_VIRTUAL_SPI_BUS_31,
    DM_VIRTUAL_SPI_BUS_32,
    MAX_DM_VIRTUAL_SPI_BUSES
};
#define IsValidDmVirtualSpiBus(a)              ( ((UINT8)a) < MAX_DM_VIRTUAL_SPI_BUSES )

#define DM_SPI_DATA_BUFFER_SIZE  1024
typedef struct
{
    UINT8 ReadBuffer[DM_SPI_DATA_BUFFER_SIZE];
    UINT32 ILastReadSize;
    UINT32 lLockHandle;
}DM_SPI_HELPER_SWITCH;

extern DM_SPI_HELPER_SWITCH g_SPIReadBuffer[MAX_DM_SPI_BUSES];

// common pattern is: instance, address, data pointer, byte cnt
extern void DmSpiInit( UINT8 bNumBuses );
extern INT32 DmSPIWriteByte(UINT32 inst, UINT8 byte);
extern INT32 DmSPIWriteBlock(UINT32 bus, UINT32 addr, UINT8 * pSrc, UINT32 byteCnt);
extern INT32 DmSPIReadBlock(UINT32 bus, UINT32 addr, UINT8 * pDest, UINT32 byteCnt);
INT32 DmSPIReadBlockFlush(UINT32 inst, UINT32 addr, UINT8 * pDest, UINT32 byteCnt, UINT8 flush);
extern void DmSPISelectDevice(UINT32 bus, UINT32 addr, BOOL level);
extern void DmSPISelectDeviceNoLock(UINT32 bus, UINT32 addr, BOOL level);
void DmSPILockBus(UINT32 spiBus, UINT8 bLocked);

extern void DmSPIRead_Configure_DMA(UINT32 spiBus, UINT8 * pDest, UINT32 byteCnt);
extern INT32 DmSPIReadBlock_DMA(UINT32 spiBus,UINT32 Timeout);

extern void DmSPI_SetDataFrameFormat(UINT32 spiBus, UINT16 DataWidth);
extern int DmReadSPI(int ignore, char *cmd);
extern int DmWriteSPI(int ignore, char *cmd);
extern int ReadDmSPIStatus(int ignore, char *cmd);

extern void DmSPITransferFullDuplex( UINT32 inst, UINT8* pSrc, UINT8* pDst, UINT32 byteCnt);

typedef enum
{
    ERR_DM_SPI_RXIN_BUFFER_OVERFLOW = 0,    // RXIn buffer overflow
    ERR_DM_SPI_INVALID_BUS,
    ERR_DM_SPI_INVALID_LOCK,
    ERR_DM_SPI_TRANSFER_ERROR,
    ERR_DM_SPI_INVALID_READ_SIZE,
    ERR_DM_SPI_CHIP_SELECT_ERROR,
    MAX_DM_SPI_ERRORS
}ERROR_DM_SPI;

extern UINT8 g_bNumDmSpiBuses;

#ifdef __cplusplus
}
#endif

#endif  //_DM_SPI_H__

